using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace BasitSayiToplamaOyunu
{
    public partial class Form1 : Form
    {

        private int gecerliToplam = 0;


        private Random randomUretici = new Random();

        public Form1()
        {
            InitializeComponent();
            FormuHazirla();
        }


        private void FormuHazirla()
        {

            btnSayi1.Enabled = false;
            btnSayi2.Enabled = false;
            btnSayi3.Enabled = false;

            txtToplam.ReadOnly = true;
            txtToplam.Text = "0";
        }


        private void btnUret_Click(object sender, EventArgs e)
        {
            int min, max;


            bool minBasarili = int.TryParse(txtMin.Text, out min);
            bool maxBasarili = int.TryParse(txtMax.Text, out max);

            if (!minBasarili || !maxBasarili)
            {
                MessageBox.Show("Ltfen minimum ve maksimum kutularna geerli saylar girin.", "Hata");
                return;
            }


            if (min >= max)
            {
                MessageBox.Show("Minimum deer, maksimum deerden kk olmaldr.", "Hata");
                return;
            }


            gecerliToplam = 0;
            txtToplam.Text = "0";


            btnSayi1.Text = randomUretici.Next(min, max + 1).ToString();
            btnSayi2.Text = randomUretici.Next(min, max + 1).ToString();
            btnSayi3.Text = randomUretici.Next(min, max + 1).ToString();


            btnSayi1.Enabled = true;
            btnSayi2.Enabled = true;
            btnSayi3.Enabled = true;
        }

        private void SayiButonu_Click(object sender, EventArgs e)
        {
            Button tiklananButon = sender as Button;

            if (int.TryParse(tiklananButon.Text, out int eklenecekSayi))
            {
                gecerliToplam += eklenecekSayi;

                txtToplam.Text = gecerliToplam.ToString();

                MessageBox.Show($"'{eklenecekSayi}' eklendi. Yeni toplam: {gecerliToplam}", "Say Eklendi");
            }
        }
    }
}